/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPFinWait_2.java
 * Author:   Gunter Weiss
 * Contents: Actions in State FIN_WAIT_2 of TCP-FSM
 * Last Changes: Gunter Weiss 23/5/97
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPFinWait_2
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPFinWait_2 {

SegArrive parent;
SessionControlBlock newtcb;
int j;

public SessionControlBlock TCPFinWait_2( SegArrive home, SessionControlBlock newtcb, int j) {

    this.parent = home;
    this.newtcb = newtcb;
    this.j = j;

    while(true) {
      System. out.println("hier in FinWait_2");
          if(parent.segment1.Seqnumb == newtcb.RCVNXT) {
    	      if(parent.segment1.FIN ==1) {
                TcpSegment sg11 = new TcpSegment();
                sg11.Lpnumb = parent.segment1.Dpnumb;
                sg11.Dpnumb = parent.segment1.Lpnumb;
                sg11.Seqnumb = parent.segment1.Acknumb;
                sg11.ACK = 1;
                sg11.Acknumb = parent.segment1.Seqnumb + 1;
       	        parent. tcppro.darfsenden.getrighttosend();
                newtcb.SNDUNA = parent.segment1.Acknumb;
                newtcb.SNDNXT = parent.segment1.Acknumb; // +1
                newtcb.RCVNXT = parent.segment1.Seqnumb + 1;
                parent. tcppro.darfsenden.giverighttosend();
                sg11.Hdlength = 5;
	        String s = "TIME_WAIT";
                sg11.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                sg11 = new Checksum().build(sg11);
                parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg11,true,new Date().getTime(),true,s));
                parent. tonet.putElement(sg11);
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 10;
	        Timeout t6 = new Timeout(parent.halt,parent.tcppro,10,parent.tcb,newtcb);
                break;
              }
              if(parent.segment1.RST==1) {
                //System.out.println("Server genau segment mit rst = 1");
                newtcb.partnerresp = -1;
                newtcb.TcpStatus = 0;
                newtcb. retqueue.removeAllElements();
                parent. fromnet.removeElementAt(0);
                parent. tcb.removeElementAt(j);
		        parent.tcppro.cid--;
                break;
              }
              if(parent.segment1.SYN ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 0;
                parent. tcb.removeElementAt(j);
    		parent.tcppro.cid--;
                break;
              }
              if(parent.segment1.ACK ==1) {
        	    newtcb. setack.setAck();
                if(parent.segment1.data.length >0) {
                  boolean b = new Buffert().buffert(newtcb.toclientbuffer,parent.segment1.data);
                  if(b == true) {
                    if(parent.segment1.PSH == 1) newtcb.userpsh = true;
                    //System.out.println("Server Daten knnten gespeichert werden");
                    TcpSegment sg8 = new TcpSegment();
                    sg8.Lpnumb = parent.segment1.Dpnumb;
                    sg8.Dpnumb = parent.segment1.Lpnumb;
                    sg8.Seqnumb = parent.segment1.Acknumb;
                    sg8.ACK = 1;
                    sg8.Hdlength = 5;
	                String s = "FIN_WAIT_2";
               	    parent. tcppro.darfsenden.getrighttosend();
                    newtcb.SNDUNA = parent.segment1.Acknumb;
                    newtcb.SNDNXT = parent.segment1.Acknumb +1 ;
                    newtcb.RCVNXT = parent.segment1.Seqnumb + parent.segment1.data.length;
                    sg8.Acknumb = newtcb.RCVNXT;
	                parent. tcppro.darfsenden.giverighttosend();
                    sg8.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                    sg8 = new Checksum().build(sg8);
                    parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg8,true,new Date().getTime(),true,s));
                    parent. tonet.putElement(sg8);
                    parent. fromnet.removeElementAt(0);
                    break;
                  }
                }
              }
          }
          parent. fromnet.removeElementAt(0);//18.07.97
    } //END while(true)
    return newtcb;
} //END methode TCPFinWait_2
} //END class TCPFinWait_2
